import javax.media.j3d.*;
import javax.vecmath.*; 
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.picking.behaviors.*;
import com.sun.j3d.utils.geometry.*;

/**
 * This demonstrates the use of the SimplePickBehaviour class.
 * When run, picking one of the cubes with the right mouse button
 * results in a messages being printed that identify which was picked.
 * @author I.J.Palmer
 * @version 1.0
 * @see SimplePickBehaviour
 */
public class SimplePick extends Frame implements ActionListener {
	protected Canvas3D myCanvas3D = new Canvas3D(null);
	protected Button exitButton = new Button("Exit");
	/** The bounds in which the behaviour is active */
        protected BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);

	/** 
	 * Build the view branch of the scene graph 
	 * @return BranchGroup that is the root of the view branch
	 * @param c Canvas3D used to display the scene
	 */
	protected BranchGroup buildViewBranch(Canvas3D c) {
		BranchGroup viewBranch = new BranchGroup();
		Transform3D viewXfm = new Transform3D();
            	viewXfm.set(new Vector3f(0.0f,0.0f,10.0f));
		TransformGroup viewXfmGroup = new TransformGroup(viewXfm);
		ViewPlatform myViewPlatform = new ViewPlatform();
            	PhysicalBody myBody = new PhysicalBody();
            	PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
		viewXfmGroup.addChild(myViewPlatform);
		viewBranch.addChild(viewXfmGroup);
		View myView = new View();
		myView.addCanvas3D(c);
		myView.attachViewPlatform(myViewPlatform);
            	myView.setPhysicalBody(myBody);
            	myView.setPhysicalEnvironment(myEnvironment);
		return viewBranch;
	}

      	/** 
	 * Add some lights to the scene graph 
	 * @param b BranchGroup to add 
	 */
	protected void addLights(BranchGroup b) {
		Color3f ambLightColour = new Color3f(0.5f, 0.5f, 0.5f);
		AmbientLight ambLight = new AmbientLight(ambLightColour);
            	ambLight.setInfluencingBounds(bounds);
            	Color3f dirLightColour = new Color3f(1.0f, 1.0f, 1.0f);
            	Vector3f dirLightDir  = new Vector3f(-1.0f, -1.0f, -1.0f);
            	DirectionalLight dirLight = new DirectionalLight(dirLightColour, dirLightDir);
            	dirLight.setInfluencingBounds(bounds);
		b.addChild(ambLight);
            	b.addChild(dirLight);
      	}

      	/** 
	 * Build the content branch 
	 * @return BranchGroup that is the root of the content branch
	 */
	protected BranchGroup buildContentBranch() {
		Appearance app1 = new Appearance();
		Appearance app2 = new Appearance();
            	Color3f ambientColour1 = new Color3f(1.0f,0.0f,0.0f);
		Color3f ambientColour2 = new Color3f(1.0f,1.0f,0.0f);
            	Color3f emissiveColour = new Color3f(0.0f,0.0f,0.0f);
		Color3f specularColour = new Color3f(1.0f,1.0f,1.0f);
            	Color3f diffuseColour1 = new Color3f(1.0f,0.0f,0.0f);
		Color3f diffuseColour2 = new Color3f(1.0f,1.0f,0.0f);
            	float shininess = 20.0f;
            	app1.setMaterial(new Material(ambientColour1,emissiveColour,
            			diffuseColour1,specularColour,shininess));
		app2.setMaterial(new Material(ambientColour2, emissiveColour,
				diffuseColour2,specularColour,shininess));
		//Make the cubes
		Box leftCube = new Box(1.0f,1.0f,1.0f, app1);
		leftCube.setUserData(new String("left cube"));
		Box rightCube = new Box(1.0f,1.0f,1.0f, app2);
		rightCube.setUserData(new String("right cube"));

		BranchGroup contentBranch = new BranchGroup();
            	addLights(contentBranch);

		Transform3D leftGroupXfm = new Transform3D();
		leftGroupXfm.set(new Vector3d(-1.5,0.0,0.0));
		TransformGroup leftGroup = new TransformGroup(leftGroupXfm);
		Transform3D rightGroupXfm = new Transform3D();
		rightGroupXfm.set(new Vector3d(1.5,0.0,0.0));
		TransformGroup rightGroup = new TransformGroup(rightGroupXfm);

		//Create the behaviour and add it to the scene
	        SimplePickRightBehaviour2 simplePick = 
			new SimplePickRightBehaviour2(myCanvas3D, contentBranch, bounds);
		contentBranch.addChild(simplePick);

		//Put the hierarchy together
		leftGroup.addChild(leftCube);
		rightGroup.addChild(rightCube);
		contentBranch.addChild(leftGroup);
		contentBranch.addChild(rightGroup);

		return contentBranch;

      	} 

	/** Process button event to exit to quit application */
	public void actionPerformed(ActionEvent e) {
		dispose();
                System.exit(0);
	}

        public SimplePick() {
		VirtualUniverse myUniverse = new VirtualUniverse();
		Locale myLocale = new Locale(myUniverse);
                myLocale.addBranchGraph(buildViewBranch(myCanvas3D));
                myLocale.addBranchGraph(buildContentBranch());
		setTitle("SimpleWorld");
		setSize(400,400);
		setLayout(new BorderLayout());
		Panel bottom = new Panel();
		bottom.add(exitButton);
                add(BorderLayout.CENTER, myCanvas3D);
                add(BorderLayout.SOUTH, bottom);
                exitButton.addActionListener(this);
                setVisible(true);
	}

	public static void main(String[] args) {
                  SimplePick sw = new SimplePick();
	}
}

